<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;

class RouteSearch extends Route
{
    public function rules()
    {
        return [
            [['id', 'user_id', 'seats_available'], 'integer'],
            [['description', 'additional_info', 'planned_date'], 'safe'],
        ];
    }

    public function search($params)
    {
        $query = Route::find()->with(['user', 'city1', 'city2', 'city3']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => ['planned_date' => SORT_ASC],
            ],
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);

        if (!($this->load($params) && $this->validate())) {
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'seats_available' => $this->seats_available,
            'planned_date' => $this->planned_date,
        ]);

        $query->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'additional_info', $this->additional_info]);

        return $dataProvider;
    }
}