<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\models\User;use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
$this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css');
$this->registerJsFile('https://code.jquery.com/jquery-3.6.0.min.js', ['position' => \yii\web\View::POS_HEAD]);
$this->registerCssFile('@web/css/main.css');
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700&family=Montserrat:wght@600;700&display=swap" rel="stylesheet">
    <?php $this->head() ?>
    <script>
        window.gm_authFailure = function() {
            alert('Ошибка загрузки Google Maps. Проверьте API ключ.');
        };
    </script>
</head>
<body class="d-flex flex-column h-100">
<?php $this->beginBody() ?>

<!--<header id="headerr">-->
<!--    --><?php
//    NavBar::begin([
//        'brandLabel' => '<img src="images/logo/logo.png" style="width: 5vw; height: 5vw;"> Vet Cat',
//        'brandUrl' => Yii::$app->homeUrl,
//        'options' => ['class' => 'headerr']
//    ]);
//    echo Nav::widget([
//        'options' => ['class' => 'navbar-nav'],
//        'items' => [
//            ['label' => 'Home', 'url' => ['/site/index']],
//            ['label' => 'Contact', 'url' => ['/site/contact']],
//            ['label' => 'Request', 'url' => ['/site/requests']],
//            ['label' => 'Kabinet', 'url' => ['/site/kabinet']],
//            Yii::$app->user->isGuest
//                ? ['label' => 'Login', 'url' => ['/site/login']]
//                : '<li class="nav-item">'
//                    . Html::beginForm(['/site/logout'])
//                    . Html::submitButton(
//                        'Logout (' . Yii::$app->user->identity->username . ')',
//                        ['class' => 'nav-link btn btn-link logout']
//                    )
//                    . Html::endForm()
//                    . '</li>'
//        ]
//    ]);
//    NavBar::end();
//    ?>
<!--</header>-->
<div class="scroll-container">
    <header>
        <div class="navbarchik">
            <div class="logo-mobile">TM</div>
            <div class="hamburger" id="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
            <nav class="nav-links" id="navLinks">
                <?= Html::a('Главная', ['/site/index'], ['class' => 'nav-link']); ?>
                <?= Html::a('Маршруты', ['/route/index'], ['class' => 'nav-link']); ?>
                <?= Html::a('Создать маршрут', ['/route/create'], ['class' => 'nav-link']); ?>

                <?php $userId = Yii::$app->user->id ?>
                <?php if($userId != null): ?>
                    <?= Html::a('Профиль', ['/site/create', 'edit' => 0], ['class' => 'nav-link']); ?>
                    <?= Html::a(
                        'Выйти',
                        ['/site/logout'],
                        [
                            'class' => 'nav-link',
                            'data' => [
                                'method' => 'post',
                            ],
                        ]
                    ); ?>
                <?php else: ?>
                    <?= Html::a('Регистрация', ['/site/register'], ['class' => 'nav-link']); ?>
                    <?= Html::a('Вход', ['/site/login'], ['class' => 'nav-link']); ?>
                <?php endif; ?>
            </nav>
        </div>
    </header>
    <div class="global-notifications">
        <?php foreach (Yii::$app->session->getAllFlashes() as $type => $message): ?>
            <div class="notification alert-<?= $type ?>">
                <div class="notification-content"><?= $message ?></div>
                <button class="notification-close">&times;</button>
            </div>
        <?php endforeach ?>
        <!-- Добавляем уведомление для информации о файле -->
        <div id="file-info-notification" class="notification" style="display: none;">
            <div id="file-info-content" class="notification-content"></div>
            <button class="notification-close">&times;</button>
        </div>
    </div>
    <main>

            <?= $content ?>

    </main>

    <script>
        document.getElementById('hamburger').addEventListener('click', function() {
            const navLinks = document.getElementById('navLinks');
            navLinks.classList.toggle('active');
            this.classList.toggle('active');
        });
        $(document).ready(function() {
            $('.global-notifications .notification').remove();

            // Функция для показа уведомления
            function showNotification(message, type, autoHide = true) {
                // Сначала закрываем все предыдущие такие же уведомления
                $('.global-notifications .notification').remove();

                const notification = $(`
            <div class="notification ${type}">
                <div class="notification-content">${message}</div>
                <button class="notification-close">&times;</button>
            </div>
        `);

                $('.global-notifications').append(notification);

                // Автоматическое закрытие
                if (autoHide) {
                    setTimeout(() => {
                        notification.addClass('hide');
                        setTimeout(() => notification.remove(), 500);
                    }, 5000);
                }

                return notification;
            }

            // Обработка закрытия уведомлений
            $(document).on('click', '.notification-close', function() {
                $(this).closest('.notification').addClass('hide');
                setTimeout(() => $(this).closest('.notification').remove(), 500);
            });

            // Показываем flash-сообщения как наши кастомные уведомления
            <?php foreach (Yii::$app->session->getAllFlashes() as $type => $message): ?>
            showNotification('<?= addslashes($message) ?>', 'alert-<?= $type ?>');
            <?php Yii::$app->session->removeFlash($type); ?>
            <?php endforeach; ?>
            // Автоматическое скрытие существующих уведомлений при загрузке
            $('.global-notifications .notification').each(function() {
                setTimeout(() => {
                    $(this).addClass('hide');
                    setTimeout(() => $(this).remove(), 500);
                }, 5000);
            });
    </script>
    <footer class="site-footer">
        <div class="footer-container">
            <!-- Основные разделы футера -->
            <div class="footer-section">
                <h3 class="footer-title">О сервисе</h3>
                <ul class="footer-links">
                    <li><?= Html::a('Главная', ['/site/index', 'edit' => 0]); ?></li>
                    <li><a href="#">Создать маршрут</a></li>
                    <li><a href="#">Маршруты</a></li>

                    <?php $userId = Yii::$app->user->id ?>
                    <?php if($userId != null): ?>
                    <li><?= Html::a('Профиль', ['/site/create', 'edit' => 0]); ?></li>
                    <li><?= Html::a(
                            'Выйти',
                            ['/site/logout'],
                            [
                                'data' => [
                                    'method' => 'post',
                                ],
                            ]
                        ); ?></li>
                    <?php else: ?>
                    <li><?= Html::a('Регистрация', ['/site/register']); ?></li>
                    <li><?= Html::a('Вход', ['/site/login']); ?></li>
                    <?php endif; ?>
                </ul>
            </div>

            <div class="footer-section">
                <h3 class="footer-title">Помощь</h3>
                <ul class="footer-links">
                    <li><a href="#">Центр поддержки</a></li>
                    <li><a href="#">Правила сервиса</a></li>
                    <li><a href="#">FAQ</a></li>
                    <li><a href="#">Контакты</a></li>
                </ul>
            </div>

            <div class="footer-section">
                <h3 class="footer-title">Соцсети</h3>
                <div class="social-links">
                    <a href="#" class="social-icon"><i class="fab fa-vk"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-telegram"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>

        <!-- Нижняя часть футера -->
        <div class="footer-bottom">
            <div class="footer-copyright">
                &copy; <?= date('Y') ?> TravelMates. Все права защищены.
            </div>
            <div class="footer-legal">
                <a href="#">Политика конфиденциальности</a>
                <a href="#">Условия использования</a>
                <a href="#">Cookie</a>
            </div>
        </div>
    </footer>
</div>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
