<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Json;

$this->title = 'Создание нового маршрута';
$this->params['breadcrumbs'][] = $this->title;
$this->registerCssFile('@web/css/r-create.css')
?>

<?php $form = ActiveForm::begin([
    'enableClientValidation' => true,
    'enableAjaxValidation' => false,
    'options' => ['class' => 'route-form']
]); ?>

<div class="form-grid">
    <div class="form-section">
        <?= $form->field($model, 'country_id')->dropDownList(
            \yii\helpers\ArrayHelper::map($countries, 'id', 'name'),
            [
                'prompt' => '— Выберите страну —',
                'class' => 'form-control',
                'id' => 'route-country_id'
            ]
        ) ?>

        <div class="map-container" id="map"></div>

        <?= $form->field($model, 'city_id_1')->hiddenInput()->label(false) ?>
        <?= $form->field($model, 'city_id_2')->hiddenInput()->label(false) ?>
        <?= $form->field($model, 'city_id_3')->hiddenInput()->label(false) ?>
    </div>

    <div class="form-section">
        <?= $form->field($model, 'description')->textarea([
            'rows' => 6,
            'class' => 'form-control',
            'placeholder' => 'Детали маршрута...'
        ]) ?>

        <?= $form->field($model, 'additional_info')->textarea([
            'rows' => 3,
            'class' => 'form-control',
            'placeholder' => 'Дополнительная информация...'
        ]) ?>

        <?= $form->field($model, 'planned_date')->input('date', [
            'options' => ['class' => 'form-control'],
            'dateFormat' => 'yyyy-MM-dd',
            'clientOptions' => [
                'minDate' => 0, // Запрет выбора прошедших дат
                'changeYear' => true,
                'changeMonth' => true,
            ],
        ]) ?>

        <?= $form->field($model, 'seats_available')->textInput([
            'type' => 'number',
            'min' => 1,
            'class' => 'form-control'
        ]) ?>

        <button type="submit" class="btn-submit">
            СОЗДАТЬ МАРШРУТ
        </button>
    </div>
</div>

<?php ActiveForm::end(); ?>
<div class="decorative-corner"></div>
<div class="decorative-line"></div>
<script src="https://api-maps.yandex.ru/2.1/?apikey=034b5e14-5637-438b-a94f-1fe96203436c&lang=ru_RU"></script>

<script>
    // Инициализация карты после загрузки API
    ymaps.ready(initMap);

    let map;
    let selectedCities = [];
    let cityPlacemarks = [];

    function initMap() {
        map = new ymaps.Map('map', {
            center: [55.7558, 37.6176], // Москва по умолчанию
            zoom: 5,
            controls: ['zoomControl']
        });

        // Обработчик выбора страны
        $('#route-country_id').change(function() {
            const countryId = $(this).val();
            if (countryId) loadCities(countryId);
        });

        // Если страна уже выбрана
        if ($('#route-country_id').val()) {
            loadCities($('#route-country_id').val());
        }
    }

    // Загрузка городов через AJAX
    function loadCities(countryId) {
        $.get('<?= Yii::$app->urlManager->createUrl(['route/get-cities']) ?>', {
            country_id: countryId
        }, function(cities) {
            // Удаляем старые метки
            map.geoObjects.removeAll();
            cityPlacemarks = [];
            selectedCities = [];
            updateHiddenFields();

            // Добавляем новые метки
            cities.forEach(function(city) {
                const placemark = new ymaps.Placemark(
                    [city.latitude, city.longitude],
                    {
                        hintContent: city.name,
                        balloonContent: city.name
                    },
                    {
                        preset: 'islands#redIcon',
                        cityId: city.id // Сохраняем ID города в свойствах метки
                    }
                );

                // Обработчик клика по метке
                placemark.events.add('click', function() {
                    toggleCitySelection(placemark);
                });

                map.geoObjects.add(placemark);
                cityPlacemarks.push(placemark);
            });

            // Центрируем карту по первому городу
            if (cities.length > 0) {
                map.setCenter([cities[0].latitude, cities[0].longitude], 6);
            }
        }).fail(function(jqXHR, textStatus, errorThrown) {
            console.error('Ошибка при загрузке городов:', textStatus, errorThrown);
        });
    }

    // Выбор/отмена выбора города
    function toggleCitySelection(placemark) {
        const cityId = placemark.options.get('cityId');
        const index = selectedCities.indexOf(cityId);

        if (index === -1) {
            if (selectedCities.length < 3) {
                selectedCities.push(cityId);
                placemark.options.set({
                    preset: 'islands#blueIcon',
                    iconContent: selectedCities.length.toString()
                });
            }
        } else {
            selectedCities.splice(index, 1);
            placemark.options.set({
                preset: 'islands#redIcon',
                iconContent: ''
            });
        }

        updateHiddenFields();
    }

    // Обновляем скрытые поля формы
    function updateHiddenFields() {
        $('#route-city_id_1').val(selectedCities[0] || '');
        $('#route-city_id_2').val(selectedCities[1] || '');
        $('#route-city_id_3').val(selectedCities[2] || '');
        const plannedDate = $('#route-planned_date').val();
        if (plannedDate) {
            // Можно добавить валидацию даты здесь
            console.log('Запланированная дата:', plannedDate);
        }
    }
</script>
<script src="https://unpkg.com/feather-icons"></script>
<script>
    feather.replace();
</script>