<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\widgets\ActiveForm;

$this->title = 'Просмотр маршрутов';
$this->params['breadcrumbs'][] = $this->title;
$this->registerCssFile('@web/css/r-index.css')
?>
<div class="route-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="route-search">
        <?php $form = ActiveForm::begin([
            'action' => ['index'],
            'method' => 'get',
            'options' => [
                'class' => 'search-form',
                'data-pjax' => 1
            ],
        ]); ?>

        <div class="search-fields">
            <?= $form->field($searchModel, 'description')->textInput(['placeholder' => 'Поиск по описанию']) ?>

            <?= $form->field($searchModel, 'planned_date')->input('date') ?>

            <?= $form->field($searchModel, 'seats_available')->dropDownList(
                [1 => '1 место', 2 => '2 места', 3 => '3 места', 4 => '4+ мест'],
                ['prompt' => 'Количество мест']
            ) ?>
        </div>

        <div class="form-group">
            <?= Html::submitButton('Поиск', ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Сбросить', ['index'], ['class' => 'btn btn-outline-secondary']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>

    <?php Pjax::begin(['id' => 'route-grid']); ?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'tableOptions' => ['class' => 'table table-striped table-bordered'],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            [
                'attribute' => 'planned_date',
                'format' => 'date',
                'headerOptions' => ['style' => 'width: 120px'],
                'filter' => Html::activeInput('date', $searchModel, 'planned_date', ['class' => 'form-control']),
            ],

            [
                'attribute' => 'description',
                'content' => function($model) {
                    return Html::tag('div',
                        Html::tag('strong', $model->description) .
                        ($model->additional_info ? '<br>' . $model->additional_info : ''),
                        ['class' => 'route-description']
                    );
                },
            ],

            [
                'attribute' => 'cities',
                'label' => 'Маршрут',
                'value' => function($model) {
                    $cities = [];
                    if ($model->city1) $cities[] = $model->city1->name;
                    if ($model->city2) $cities[] = $model->city2->name;
                    if ($model->city3) $cities[] = $model->city3->name;
                    return implode(' → ', $cities);
                },
                'format' => 'raw',
            ],

            [
                'attribute' => 'seats_available',
                'headerOptions' => ['style' => 'width: 100px'],
                'content' => function($model) {
                    return Html::tag('span', $model->seats_available, [
                        'class' => 'badge ' . ($model->seats_available > 2 ? 'badge-success' : 'badge-warning')
                    ]);
                },
            ],

            [
                'attribute' => 'user.username',
                'label' => 'Автор',
                'format' => 'raw',
                'value' => function($model) {
                    return Html::a($model->user->username, ['site/profile', 'id' => $model->user_id]);
                },
            ],

            [
                'class' => 'yii\grid\ActionColumn',
                'headerOptions' => ['style' => 'width: 120px'],
                'template' => '{join}',
                'buttons' => [
                    'join' => function ($url, $model, $key) {
                        return Html::a('Присоединиться', $url, [
                            'class' => 'btn btn-success btn-sm',
                            'data' => [
                                'confirm' => 'Вы точно хотите присоединиться к этому маршруту?',
                                'method' => 'post',
                            ],
                        ]);
                    },
                ],
                'visibleButtons' => [
                    'join' => function ($model, $key, $index) {
                        // Проверяем есть ли свободные места
                        return empty($model->user_id_2) || empty($model->user_id_3) ||
                            empty($model->user_id_4) || empty($model->user_id_5);
                    }
                ]
            ],
        ],
    ]); ?>
    <?php Pjax::end(); ?>
</div>
<script>
    $(document).on('ready pjax:success', function() {
        // Инициализация плагинов, если нужно
    });

    $(document).on('submit', '.search-form', function(e) {
        e.preventDefault();
        $.pjax.submit(e.target, '#route-grid', {
            push: true,
            replace: false,
            timeout: 1000
        });
    });
</script>